// Hitwindow: how many steps before actual gun fire (early press)
var stepsBefore = 2;
// Hitwindow: how many steps after actual gun fire (late press)
var stepsAfter = 2;

mechSpr = new FlxSprite();
var timeout = 0;
var dodgeTimeout = 0;
var canDodge = false;
mechSpr.frames = Paths.getSparrowAtlas('game/mechanics/sanic/dodgie');
mechSpr.animation.addByPrefix('one', 'one', 24, false);
mechSpr.animation.addByPrefix('two', 'two', 24, false);
mechSpr.animation.addByPrefix('three', 'three', 24, false);
mechSpr.animation.addByPrefix('hit', 'hit', 24, false);
mechSpr.animation.addByPrefix('miss', 'miss', 24, false);
// mechSpr.playAnim('one');
mechSpr.updateHitbox();
mechSpr.visible = false;
mechSpr.antialiasing = false;
mechSpr.scale.set(0.8, 0.8);
mechSpr.cameras = [camHUD];
mechSpr.screenCenter(FlxAxes.X);
mechSpr.y += 120;
var warning1:FlxSound = FlxG.sound.load(Paths.sound("sanic/warning1"));
var warning2:FlxSound = FlxG.sound.load(Paths.sound("sanic/warning2"));
var miss:FlxSound = FlxG.sound.load(Paths.sound("sanic/nope"));

function postCreate() {
	add(mechSpr);
}

function onEvent(__event) {
	if (__event.event.name == "Sanic Dodge") {
		// prep values
		timeout = 16;
		dodgeTimeout = stepsBefore + stepsAfter;

		mechSpr.animation.play('one', true);
		mechSpr.visible = true;
		warning1.play(true);
	}
}

/**
 * Runs when the player DID press SPACE in the allocated time.
 */
function spacePressed() {
	canDodge = false;

	// dad anims
	dad.playAnim("snipe");
	if (FlxG.save.data.flashing_toggle) {
		FlxG.camera.shake(0.03, 0.15, null, true);
	}

	// bf anims
	boyfriend.playAnim("dodge");
	mechSpr.animation.play('hit', true);

	if ((PlayState.SONG.meta.name == "no scope") && FlxG.save.data.flashing_toggle) {
		camGame.zoom = 2;
		camFollow.setPosition(600, 300);
		FlxG.camera.snapToTarget();
		camGame.followLerp = 0;
		holdItRightThere = new FlxTimer().start(0.3, () -> {
			camGame.followLerp = 0.04;
		});
	}
}

/**
 * Runs when the player didn't press SPACE on time (2 beats early, 2 beats late)
 */
function spaceForgotten() {
	canDodge = false;
	mechSpr.animation.play('miss', true);
	health -= 1.2;
	// if (PlayState.SONG.meta.name == "no scope") health -= 1.9; else health -= 0.9;
	miss.play(true);
}

function stepHit(step) {
	if (timeout > 0)
		timeout--;

	if (canDodge) 
		if (dodgeTimeout > 0)
			dodgeTimeout--;
	else
		spaceForgotten();
	
	if (FlxG.save.data.botplay_toggle && canDodge && dodgeTimeout == 2) {
		spacePressed();
		return;
	}
	switch (timeout) {
		case 12: // +1 beat
			mechSpr.animation.play('two', true);
			warning2.play(true);
		case 8: // +2 beat
			mechSpr.animation.play('three', true);
			warning1.play(true);
		case stepsBefore + 4:
			canDodge = true;
		case 0:
			mechSpr.visible = false;
	}
}

function update(elapsed) {
	if (canDodge && FlxG.keys.justPressed.SPACE && !FlxG.save.data.botplay_toggle) {
		spacePressed();
	}
}
